'use client';

import React from 'react';
import {
    Box,
    Container,
    Typography,
    Grid,
    Card,
    CardContent,
    Button,
    Stepper,
    Step,
    StepLabel,
    StepContent,
} from '@mui/material';
import { Search, Chat, Payment, CheckCircle, TrendingUp, Security } from '@mui/icons-material';
import Header from '@/components/Header';
import Footer from '@/components/Footer';

export default function HowItWorksPage() {
    const clientSteps = [
        {
            label: 'Post Your Project or Browse Services',
            description: 'Describe your project needs or browse through thousands of services offered by talented freelancers.',
            icon: <Search sx={{ fontSize: 40 }} />,
        },
        {
            label: 'Find the Perfect Freelancer',
            description: 'Review portfolios, ratings, and reviews to find the right professional for your project.',
            icon: <TrendingUp sx={{ fontSize: 40 }} />,
        },
        {
            label: 'Collaborate and Communicate',
            description: 'Work directly with your freelancer through our messaging system. Track progress and provide feedback.',
            icon: <Chat sx={{ fontSize: 40 }} />,
        },
        {
            label: 'Pay Securely',
            description: 'Funds are held in escrow and released only when you approve the delivered work.',
            icon: <Payment sx={{ fontSize: 40 }} />,
        },
        {
            label: 'Leave a Review',
            description: 'Share your experience to help other clients and support great freelancers.',
            icon: <CheckCircle sx={{ fontSize: 40 }} />,
        },
    ];

    const freelancerSteps = [
        {
            label: 'Create Your Profile',
            description: 'Build a compelling profile showcasing your skills, experience, and portfolio.',
            icon: <Search sx={{ fontSize: 40 }} />,
        },
        {
            label: 'Create Service Listings',
            description: 'Offer your services with clear packages, pricing, and delivery times.',
            icon: <TrendingUp sx={{ fontSize: 40 }} />,
        },
        {
            label: 'Receive Orders',
            description: 'Get notified when clients order your services or invite you to their projects.',
            icon: <Chat sx={{ fontSize: 40 }} />,
        },
        {
            label: 'Deliver Quality Work',
            description: 'Complete the project according to requirements and deliver on time.',
            icon: <CheckCircle sx={{ fontSize: 40 }} />,
        },
        {
            label: 'Get Paid',
            description: 'Receive payment securely once the client approves your work.',
            icon: <Payment sx={{ fontSize: 40 }} />,
        },
    ];

    const features = [
        {
            icon: <Security sx={{ fontSize: 50 }} />,
            title: 'Secure Payments',
            description: 'All transactions are protected with escrow and encrypted payment processing.',
        },
        {
            icon: <Chat sx={{ fontSize: 50 }} />,
            title: '24/7 Support',
            description: 'Our dedicated support team is always here to help you succeed.',
        },
        {
            icon: <CheckCircle sx={{ fontSize: 50 }} />,
            title: 'Quality Guarantee',
            description: 'Work with confidence knowing you can request revisions until satisfied.',
        },
    ];

    return (
        <>
            <Header />

            {/* Hero Section */}
            <Box
                sx={{
                    background: 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
                    color: 'white',
                    py: 10,
                }}
            >
                <Container maxWidth="md" sx={{ textAlign: 'center' }}>
                    <Typography variant="h2" fontWeight={700} gutterBottom>
                        How It Works
                    </Typography>
                    <Typography variant="h5" sx={{ opacity: 0.9 }}>
                        Get started in minutes, whether you're hiring or freelancing
                    </Typography>
                </Container>
            </Box>

            {/* For Clients */}
            <Container maxWidth="lg" sx={{ mt: 8, mb: 8 }}>
                <Typography variant="h3" fontWeight={700} textAlign="center" gutterBottom>
                    For Clients
                </Typography>
                <Typography variant="h6" color="text.secondary" textAlign="center" sx={{ mb: 6 }}>
                    Find and hire talented freelancers for your projects
                </Typography>

                <Grid container spacing={4}>
                    {clientSteps.map((step, index) => (
                        <Grid item xs={12} md={6} lg={4} key={index}>
                            <Card sx={{ height: '100%', p: 3 }}>
                                <Box
                                    sx={{
                                        width: 80,
                                        height: 80,
                                        borderRadius: '50%',
                                        background: 'linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%)',
                                        display: 'flex',
                                        alignItems: 'center',
                                        justifyContent: 'center',
                                        margin: '0 auto 16px',
                                        color: 'white',
                                    }}
                                >
                                    {step.icon}
                                </Box>
                                <Typography variant="h6" fontWeight={600} gutterBottom textAlign="center">
                                    {index + 1}. {step.label}
                                </Typography>
                                <Typography variant="body2" color="text.secondary" textAlign="center">
                                    {step.description}
                                </Typography>
                            </Card>
                        </Grid>
                    ))}
                </Grid>

                <Box sx={{ textAlign: 'center', mt: 4 }}>
                    <Button variant="contained" size="large" href="/register">
                        Start Hiring
                    </Button>
                </Box>
            </Container>

            {/* For Freelancers */}
            <Box sx={{ bgcolor: 'background.default', py: 8 }}>
                <Container maxWidth="lg">
                    <Typography variant="h3" fontWeight={700} textAlign="center" gutterBottom>
                        For Freelancers
                    </Typography>
                    <Typography variant="h6" color="text.secondary" textAlign="center" sx={{ mb: 6 }}>
                        Build your freelance career and earn money doing what you love
                    </Typography>

                    <Grid container spacing={4}>
                        {freelancerSteps.map((step, index) => (
                            <Grid item xs={12} md={6} lg={4} key={index}>
                                <Card sx={{ height: '100%', p: 3 }}>
                                    <Box
                                        sx={{
                                            width: 80,
                                            height: 80,
                                            borderRadius: '50%',
                                            background: 'linear-gradient(135deg, #10b981 0%, #059669 100%)',
                                            display: 'flex',
                                            alignItems: 'center',
                                            justifyContent: 'center',
                                            margin: '0 auto 16px',
                                            color: 'white',
                                        }}
                                    >
                                        {step.icon}
                                    </Box>
                                    <Typography variant="h6" fontWeight={600} gutterBottom textAlign="center">
                                        {index + 1}. {step.label}
                                    </Typography>
                                    <Typography variant="body2" color="text.secondary" textAlign="center">
                                        {step.description}
                                    </Typography>
                                </Card>
                            </Grid>
                        ))}
                    </Grid>

                    <Box sx={{ textAlign: 'center', mt: 4 }}>
                        <Button variant="contained" size="large" href="/register">
                            Start Freelancing
                        </Button>
                    </Box>
                </Container>
            </Box>

            {/* Features */}
            <Container maxWidth="lg" sx={{ mt: 8, mb: 8 }}>
                <Typography variant="h3" fontWeight={700} textAlign="center" gutterBottom>
                    Why Choose Us
                </Typography>
                <Typography variant="h6" color="text.secondary" textAlign="center" sx={{ mb: 6 }}>
                    We provide everything you need for successful collaborations
                </Typography>

                <Grid container spacing={4}>
                    {features.map((feature) => (
                        <Grid item xs={12} md={4} key={feature.title}>
                            <Card sx={{ height: '100%', textAlign: 'center', p: 4 }}>
                                <Box sx={{ color: 'primary.main', mb: 2 }}>{feature.icon}</Box>
                                <Typography variant="h5" fontWeight={600} gutterBottom>
                                    {feature.title}
                                </Typography>
                                <Typography variant="body1" color="text.secondary">
                                    {feature.description}
                                </Typography>
                            </Card>
                        </Grid>
                    ))}
                </Grid>
            </Container>

            {/* CTA */}
            <Box
                sx={{
                    background: 'linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%)',
                    color: 'white',
                    py: 8,
                    textAlign: 'center',
                }}
            >
                <Container maxWidth="md">
                    <Typography variant="h3" fontWeight={700} gutterBottom>
                        Ready to Get Started?
                    </Typography>
                    <Typography variant="h6" sx={{ mb: 4, opacity: 0.9 }}>
                        Join thousands of satisfied clients and freelancers today
                    </Typography>
                    <Button
                        variant="contained"
                        size="large"
                        href="/register"
                        sx={{
                            bgcolor: 'white',
                            color: 'primary.main',
                            '&:hover': { bgcolor: 'rgba(255,255,255,0.9)' },
                        }}
                    >
                        Create Free Account
                    </Button>
                </Container>
            </Box>

            <Footer />
        </>
    );
}
