'use client';

import React from 'react';
import { Card, CardContent, Typography, Box } from '@mui/material';
import Link from 'next/link';

interface CategoryCardProps {
    id: number;
    name: string;
    icon: string;
    count: number;
    color: string;
}

export default function CategoryCard({ id, name, icon, count, color }: CategoryCardProps) {
    return (
        <Link href={`/services?category=${encodeURIComponent(name)}`} style={{ textDecoration: 'none' }}>
            <Card
                sx={{
                    height: '100%',
                    cursor: 'pointer',
                    transition: 'all 0.3s ease',
                    '&:hover': {
                        transform: 'translateY(-8px)',
                        boxShadow: 6,
                        '& .category-icon': {
                            transform: 'scale(1.1) rotate(5deg)',
                        },
                    },
                }}
            >
                <CardContent sx={{ textAlign: 'center', p: 3 }}>
                    <Box
                        className="category-icon"
                        sx={{
                            fontSize: '3rem',
                            mb: 2,
                            transition: 'transform 0.3s ease',
                        }}
                    >
                        {icon}
                    </Box>
                    <Typography variant="h6" fontWeight={600} gutterBottom>
                        {name}
                    </Typography>
                    <Typography variant="body2" color="text.secondary">
                        {count.toLocaleString()} services
                    </Typography>
                </CardContent>
            </Card>
        </Link>
    );
}
