'use client';

import React from 'react';
import {
    Box,
    Container,
    Grid,
    Typography,
    TextField,
    Button,
    IconButton,
    Link as MuiLink,
    Divider,
} from '@mui/material';
import {
    Facebook,
    Twitter,
    Instagram,
    LinkedIn,
    Send,
} from '@mui/icons-material';
import Link from 'next/link';

const footerLinks = {
    'For Clients': [
        { label: 'How to Hire', href: '#' },
        { label: 'Talent Marketplace', href: '#' },
        { label: 'Project Catalog', href: '#' },
        { label: 'Enterprise', href: '#' },
    ],
    'For Freelancers': [
        { label: 'How to Find Work', href: '#' },
        { label: 'Direct Contracts', href: '#' },
        { label: 'Find Freelance Jobs', href: '#' },
        { label: 'Freelancer Resources', href: '#' },
    ],
    'Resources': [
        { label: 'Help & Support', href: '#' },
        { label: 'Success Stories', href: '#' },
        { label: 'Reviews', href: '#' },
        { label: 'Blog', href: '#' },
    ],
    'Company': [
        { label: 'About Us', href: '/about' },
        { label: 'Contact', href: '/contact' },
        { label: 'Careers', href: '#' },
        { label: 'Privacy Policy', href: '#' },
    ],
};

export default function Footer() {
    return (
        <Box
            component="footer"
            sx={{
                background: 'linear-gradient(135deg, #1e293b 0%, #0f172a 100%)',
                color: 'white',
                pt: 8,
                pb: 4,
                mt: 8,
            }}
        >
            <Container maxWidth="xl">
                {/* Newsletter Section */}
                <Box
                    sx={{
                        backgroundColor: 'rgba(99, 102, 241, 0.1)',
                        borderRadius: 3,
                        p: 4,
                        mb: 6,
                        border: '1px solid rgba(99, 102, 241, 0.2)',
                    }}
                >
                    <Grid container spacing={3} alignItems="center">
                        <Grid item xs={12} md={6}>
                            <Typography variant="h5" fontWeight={700} gutterBottom>
                                Subscribe to Our Newsletter
                            </Typography>
                            <Typography variant="body2" sx={{ opacity: 0.8 }}>
                                Get the latest updates on new projects and freelance opportunities
                            </Typography>
                        </Grid>
                        <Grid item xs={12} md={6}>
                            <Box sx={{ display: 'flex', gap: 1 }}>
                                <TextField
                                    fullWidth
                                    placeholder="Enter your email"
                                    size="small"
                                    sx={{
                                        '& .MuiOutlinedInput-root': {
                                            backgroundColor: 'white',
                                            '& fieldset': {
                                                borderColor: 'transparent',
                                            },
                                        },
                                    }}
                                />
                                <Button
                                    variant="contained"
                                    endIcon={<Send />}
                                    sx={{
                                        background: 'linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%)',
                                        whiteSpace: 'nowrap',
                                    }}
                                >
                                    Subscribe
                                </Button>
                            </Box>
                        </Grid>
                    </Grid>
                </Box>

                {/* Links Section */}
                <Grid container spacing={4} sx={{ mb: 6 }}>
                    <Grid item xs={12} md={3}>
                        <Typography
                            variant="h4"
                            fontWeight={700}
                            sx={{
                                background: 'linear-gradient(135deg, #6366f1 0%, #8b5cf6 100%)',
                                WebkitBackgroundClip: 'text',
                                WebkitTextFillColor: 'transparent',
                                mb: 2,
                            }}
                        >
                            Freeio
                        </Typography>
                        <Typography variant="body2" sx={{ opacity: 0.8, mb: 3 }}>
                            The world's largest freelance marketplace. Connect with talented professionals and grow your business.
                        </Typography>
                        <Box sx={{ display: 'flex', gap: 1 }}>
                            <IconButton
                                sx={{
                                    color: 'white',
                                    backgroundColor: 'rgba(255, 255, 255, 0.1)',
                                    '&:hover': {
                                        backgroundColor: 'rgba(99, 102, 241, 0.8)',
                                    },
                                }}
                            >
                                <Facebook />
                            </IconButton>
                            <IconButton
                                sx={{
                                    color: 'white',
                                    backgroundColor: 'rgba(255, 255, 255, 0.1)',
                                    '&:hover': {
                                        backgroundColor: 'rgba(99, 102, 241, 0.8)',
                                    },
                                }}
                            >
                                <Twitter />
                            </IconButton>
                            <IconButton
                                sx={{
                                    color: 'white',
                                    backgroundColor: 'rgba(255, 255, 255, 0.1)',
                                    '&:hover': {
                                        backgroundColor: 'rgba(99, 102, 241, 0.8)',
                                    },
                                }}
                            >
                                <Instagram />
                            </IconButton>
                            <IconButton
                                sx={{
                                    color: 'white',
                                    backgroundColor: 'rgba(255, 255, 255, 0.1)',
                                    '&:hover': {
                                        backgroundColor: 'rgba(99, 102, 241, 0.8)',
                                    },
                                }}
                            >
                                <LinkedIn />
                            </IconButton>
                        </Box>
                    </Grid>

                    {Object.entries(footerLinks).map(([category, links]) => (
                        <Grid item xs={6} sm={6} md={2.25} key={category}>
                            <Typography variant="h6" fontWeight={600} gutterBottom>
                                {category}
                            </Typography>
                            <Box sx={{ display: 'flex', flexDirection: 'column', gap: 1 }}>
                                {links.map((link) => (
                                    <MuiLink
                                        key={link.label}
                                        component={Link}
                                        href={link.href}
                                        sx={{
                                            color: 'rgba(255, 255, 255, 0.7)',
                                            textDecoration: 'none',
                                            fontSize: '0.875rem',
                                            '&:hover': {
                                                color: 'white',
                                                textDecoration: 'underline',
                                            },
                                        }}
                                    >
                                        {link.label}
                                    </MuiLink>
                                ))}
                            </Box>
                        </Grid>
                    ))}
                </Grid>

                <Divider sx={{ borderColor: 'rgba(255, 255, 255, 0.1)', mb: 3 }} />

                {/* Copyright */}
                <Box
                    sx={{
                        display: 'flex',
                        flexDirection: { xs: 'column', sm: 'row' },
                        justifyContent: 'space-between',
                        alignItems: 'center',
                        gap: 2,
                    }}
                >
                    <Typography variant="body2" sx={{ opacity: 0.7 }}>
                        © 2024 Freeio. All rights reserved.
                    </Typography>
                    <Box sx={{ display: 'flex', gap: 3 }}>
                        <MuiLink
                            href="#"
                            sx={{
                                color: 'rgba(255, 255, 255, 0.7)',
                                textDecoration: 'none',
                                fontSize: '0.875rem',
                                '&:hover': {
                                    color: 'white',
                                },
                            }}
                        >
                            Terms of Service
                        </MuiLink>
                        <MuiLink
                            href="#"
                            sx={{
                                color: 'rgba(255, 255, 255, 0.7)',
                                textDecoration: 'none',
                                fontSize: '0.875rem',
                                '&:hover': {
                                    color: 'white',
                                },
                            }}
                        >
                            Privacy Policy
                        </MuiLink>
                    </Box>
                </Box>
            </Container>
        </Box>
    );
}
