export const categories = [
    {
        id: 1,
        name: 'Graphics & Design',
        icon: '🎨',
        count: 1250,
        color: '#f59e0b',
    },
    {
        id: 2,
        name: 'Digital Marketing',
        icon: '📱',
        count: 980,
        color: '#10b981',
    },
    {
        id: 3,
        name: 'Writing & Translation',
        icon: '✍️',
        count: 1450,
        color: '#6366f1',
    },
    {
        id: 4,
        name: 'Video & Animation',
        icon: '🎬',
        count: 820,
        color: '#ef4444',
    },
    {
        id: 5,
        name: 'Music & Audio',
        icon: '🎵',
        count: 650,
        color: '#8b5cf6',
    },
    {
        id: 6,
        name: 'Programming & Tech',
        icon: '💻',
        count: 2100,
        color: '#06b6d4',
    },
    {
        id: 7,
        name: 'Business',
        icon: '💼',
        count: 890,
        color: '#f97316',
    },
    {
        id: 8,
        name: 'Lifestyle',
        icon: '🌟',
        count: 560,
        color: '#ec4899',
    },
];

export const services = [
    {
        id: 1,
        title: 'I will design a modern logo for your business',
        category: 'Graphics & Design',
        image: 'https://images.unsplash.com/photo-1626785774573-4b799315345d?w=800&h=600&fit=crop',
        provider: {
            id: 1,
            name: 'Sarah Johnson',
            avatar: 'https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=100&h=100&fit=crop',
            rating: 4.9,
            reviews: 342,
        },
        price: 150,
        featured: true,
        rating: 4.9,
        reviewCount: 342,
        deliveryTime: '3 days',
    },
    {
        id: 2,
        title: 'Professional SEO optimization for your website',
        category: 'Digital Marketing',
        image: 'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=800&h=600&fit=crop',
        provider: {
            id: 2,
            name: 'Michael Chen',
            avatar: 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=100&h=100&fit=crop',
            rating: 5.0,
            reviews: 521,
        },
        price: 200,
        featured: true,
        rating: 5.0,
        reviewCount: 521,
        deliveryTime: '5 days',
    },
    {
        id: 3,
        title: 'Write engaging blog content and articles',
        category: 'Writing & Translation',
        image: 'https://images.unsplash.com/photo-1455390582262-044cdead277a?w=800&h=600&fit=crop',
        provider: {
            id: 3,
            name: 'Emma Williams',
            avatar: 'https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=100&h=100&fit=crop',
            rating: 4.8,
            reviews: 289,
        },
        price: 80,
        featured: true,
        rating: 4.8,
        reviewCount: 289,
        deliveryTime: '2 days',
    },
    {
        id: 4,
        title: 'Create stunning video animations',
        category: 'Video & Animation',
        image: 'https://images.unsplash.com/photo-1574717024653-61fd2cf4d44d?w=800&h=600&fit=crop',
        provider: {
            id: 4,
            name: 'David Martinez',
            avatar: 'https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=100&h=100&fit=crop',
            rating: 4.7,
            reviews: 198,
        },
        price: 350,
        featured: false,
        rating: 4.7,
        reviewCount: 198,
        deliveryTime: '7 days',
    },
    {
        id: 5,
        title: 'Professional voice over for your project',
        category: 'Music & Audio',
        image: 'https://images.unsplash.com/photo-1590602847861-f357a9332bbc?w=800&h=600&fit=crop',
        provider: {
            id: 5,
            name: 'Lisa Anderson',
            avatar: 'https://images.unsplash.com/photo-1487412720507-e7ab37603c6f?w=100&h=100&fit=crop',
            rating: 4.9,
            reviews: 412,
        },
        price: 120,
        featured: false,
        rating: 4.9,
        reviewCount: 412,
        deliveryTime: '3 days',
    },
    {
        id: 6,
        title: 'Full-stack web application development',
        category: 'Programming & Tech',
        image: 'https://images.unsplash.com/photo-1498050108023-c5249f4df085?w=800&h=600&fit=crop',
        provider: {
            id: 6,
            name: 'James Wilson',
            avatar: 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=100&h=100&fit=crop',
            rating: 5.0,
            reviews: 678,
        },
        price: 500,
        featured: true,
        rating: 5.0,
        reviewCount: 678,
        deliveryTime: '14 days',
    },
    {
        id: 7,
        title: 'Business plan and financial modeling',
        category: 'Business',
        image: 'https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?w=800&h=600&fit=crop',
        provider: {
            id: 7,
            name: 'Rachel Green',
            avatar: 'https://images.unsplash.com/photo-1489424731084-a5d8b219a5bb?w=100&h=100&fit=crop',
            rating: 4.8,
            reviews: 234,
        },
        price: 250,
        featured: false,
        rating: 4.8,
        reviewCount: 234,
        deliveryTime: '5 days',
    },
    {
        id: 8,
        title: 'Personal fitness and nutrition coaching',
        category: 'Lifestyle',
        image: 'https://images.unsplash.com/photo-1571019614242-c5c5dee9f50b?w=800&h=600&fit=crop',
        provider: {
            id: 8,
            name: 'Tom Harris',
            avatar: 'https://images.unsplash.com/photo-1463453091185-61582044d556?w=100&h=100&fit=crop',
            rating: 4.9,
            reviews: 567,
        },
        price: 100,
        featured: false,
        rating: 4.9,
        reviewCount: 567,
        deliveryTime: '1 day',
    },
    {
        id: 9,
        title: 'Social media management and content creation',
        category: 'Digital Marketing',
        image: 'https://images.unsplash.com/photo-1611162617474-5b21e879e113?w=800&h=600&fit=crop',
        provider: {
            id: 2,
            name: 'Michael Chen',
            avatar: 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=100&h=100&fit=crop',
            rating: 5.0,
            reviews: 521,
        },
        price: 180,
        featured: true,
        rating: 5.0,
        reviewCount: 421,
        deliveryTime: '4 days',
    },
    {
        id: 10,
        title: 'Professional product photography',
        category: 'Graphics & Design',
        image: 'https://images.unsplash.com/photo-1505740420928-5e560c06d30e?w=800&h=600&fit=crop',
        provider: {
            id: 9,
            name: 'Alex Turner',
            avatar: 'https://images.unsplash.com/photo-1506794778202-cad84cf45f1d?w=100&h=100&fit=crop',
            rating: 4.8,
            reviews: 156,
        },
        price: 220,
        featured: false,
        rating: 4.8,
        reviewCount: 156,
        deliveryTime: '3 days',
    },
    {
        id: 11,
        title: 'Mobile app UI/UX design',
        category: 'Graphics & Design',
        image: 'https://images.unsplash.com/photo-1512941937669-90a1b58e7e9c?w=800&h=600&fit=crop',
        provider: {
            id: 1,
            name: 'Sarah Johnson',
            avatar: 'https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=100&h=100&fit=crop',
            rating: 4.9,
            reviews: 342,
        },
        price: 400,
        featured: true,
        rating: 4.9,
        reviewCount: 298,
        deliveryTime: '7 days',
    },
    {
        id: 12,
        title: 'WordPress website development',
        category: 'Programming & Tech',
        image: 'https://images.unsplash.com/photo-1547658719-da2b51169166?w=800&h=600&fit=crop',
        provider: {
            id: 10,
            name: 'Chris Brown',
            avatar: 'https://images.unsplash.com/photo-1519345182560-3f2917c472ef?w=100&h=100&fit=crop',
            rating: 4.7,
            reviews: 289,
        },
        price: 350,
        featured: false,
        rating: 4.7,
        reviewCount: 289,
        deliveryTime: '10 days',
    },
    {
        id: 13,
        title: 'Email marketing campaign setup',
        category: 'Digital Marketing',
        image: 'https://images.unsplash.com/photo-1563986768609-322da13575f3?w=800&h=600&fit=crop',
        provider: {
            id: 11,
            name: 'Nina Patel',
            avatar: 'https://images.unsplash.com/photo-1534528741775-53994a69daeb?w=100&h=100&fit=crop',
            rating: 4.9,
            reviews: 234,
        },
        price: 150,
        featured: false,
        rating: 4.9,
        reviewCount: 234,
        deliveryTime: '3 days',
    },
    {
        id: 14,
        title: 'Podcast editing and production',
        category: 'Music & Audio',
        image: 'https://images.unsplash.com/photo-1478737270239-2f02b77fc618?w=800&h=600&fit=crop',
        provider: {
            id: 12,
            name: 'Ryan Cooper',
            avatar: 'https://images.unsplash.com/photo-1492562080023-ab3db95bfbce?w=100&h=100&fit=crop',
            rating: 4.8,
            reviews: 178,
        },
        price: 90,
        featured: false,
        rating: 4.8,
        reviewCount: 178,
        deliveryTime: '2 days',
    },
    {
        id: 15,
        title: 'Whiteboard animation videos',
        category: 'Video & Animation',
        image: 'https://images.unsplash.com/photo-1611162616305-c69b3fa7fbe0?w=800&h=600&fit=crop',
        provider: {
            id: 4,
            name: 'David Martinez',
            avatar: 'https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=100&h=100&fit=crop',
            rating: 4.7,
            reviews: 198,
        },
        price: 280,
        featured: false,
        rating: 4.7,
        reviewCount: 145,
        deliveryTime: '5 days',
    },
    {
        id: 16,
        title: 'Technical writing and documentation',
        category: 'Writing & Translation',
        image: 'https://images.unsplash.com/photo-1434030216411-0b793f4b4173?w=800&h=600&fit=crop',
        provider: {
            id: 13,
            name: 'Olivia Martinez',
            avatar: 'https://images.unsplash.com/photo-1544005313-94ddf0286df2?w=100&h=100&fit=crop',
            rating: 4.9,
            reviews: 267,
        },
        price: 120,
        featured: false,
        rating: 4.9,
        reviewCount: 267,
        deliveryTime: '4 days',
    },
    {
        id: 17,
        title: 'Virtual assistant services',
        category: 'Business',
        image: 'https://images.unsplash.com/photo-1553877522-43269d4ea984?w=800&h=600&fit=crop',
        provider: {
            id: 14,
            name: 'Sophia Lee',
            avatar: 'https://images.unsplash.com/photo-1508214751196-bcfd4ca60f91?w=100&h=100&fit=crop',
            rating: 4.8,
            reviews: 412,
        },
        price: 60,
        featured: false,
        rating: 4.8,
        reviewCount: 412,
        deliveryTime: '1 day',
    },
    {
        id: 18,
        title: 'Brand identity design package',
        category: 'Graphics & Design',
        image: 'https://images.unsplash.com/photo-1561070791-2526d30994b5?w=800&h=600&fit=crop',
        provider: {
            id: 1,
            name: 'Sarah Johnson',
            avatar: 'https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=100&h=100&fit=crop',
            rating: 4.9,
            reviews: 342,
        },
        price: 600,
        featured: true,
        rating: 4.9,
        reviewCount: 278,
        deliveryTime: '10 days',
    },
    {
        id: 19,
        title: 'Python automation scripts',
        category: 'Programming & Tech',
        image: 'https://images.unsplash.com/photo-1526374965328-7f61d4dc18c5?w=800&h=600&fit=crop',
        provider: {
            id: 6,
            name: 'James Wilson',
            avatar: 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=100&h=100&fit=crop',
            rating: 5.0,
            reviews: 678,
        },
        price: 180,
        featured: false,
        rating: 5.0,
        reviewCount: 523,
        deliveryTime: '3 days',
    },
    {
        id: 20,
        title: 'Yoga and meditation coaching',
        category: 'Lifestyle',
        image: 'https://images.unsplash.com/photo-1544367567-0f2fcb009e0b?w=800&h=600&fit=crop',
        provider: {
            id: 15,
            name: 'Maya Singh',
            avatar: 'https://images.unsplash.com/photo-1531123897727-8f129e1688ce?w=100&h=100&fit=crop',
            rating: 5.0,
            reviews: 389,
        },
        price: 75,
        featured: false,
        rating: 5.0,
        reviewCount: 389,
        deliveryTime: '1 day',
    },
];

export const freelancers = [
    {
        id: 1,
        name: 'Sarah Johnson',
        title: 'Senior Graphic Designer',
        avatar: 'https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=200&h=200&fit=crop',
        rating: 4.9,
        reviews: 342,
        completedProjects: 450,
        hourlyRate: 75,
        skills: ['Logo Design', 'Branding', 'Illustration', 'UI/UX'],
        location: 'New York, USA',
        isPremium: true,
        bio: 'Award-winning graphic designer with 10+ years of experience creating stunning visual identities for global brands.',
        languages: ['English', 'Spanish'],
        responseTime: '1 hour',
        memberSince: '2019',
    },
    {
        id: 2,
        name: 'Michael Chen',
        title: 'SEO & Marketing Expert',
        avatar: 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=200&h=200&fit=crop',
        rating: 5.0,
        reviews: 521,
        completedProjects: 680,
        hourlyRate: 90,
        skills: ['SEO', 'Content Marketing', 'Google Ads', 'Analytics'],
        location: 'San Francisco, USA',
        isPremium: true,
        bio: 'Digital marketing strategist helping businesses grow their online presence and drive measurable results.',
        languages: ['English', 'Mandarin'],
        responseTime: '2 hours',
        memberSince: '2018',
    },
    {
        id: 3,
        name: 'Emma Williams',
        title: 'Content Writer & Editor',
        avatar: 'https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=200&h=200&fit=crop',
        rating: 4.8,
        reviews: 289,
        completedProjects: 520,
        hourlyRate: 60,
        skills: ['Blog Writing', 'Copywriting', 'Editing', 'Research'],
        location: 'London, UK',
        isPremium: false,
        bio: 'Professional writer crafting engaging content that connects with audiences and drives engagement.',
        languages: ['English', 'French'],
        responseTime: '3 hours',
        memberSince: '2020',
    },
    {
        id: 4,
        name: 'David Martinez',
        title: 'Video & Animation Specialist',
        avatar: 'https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=200&h=200&fit=crop',
        rating: 4.7,
        reviews: 198,
        completedProjects: 245,
        hourlyRate: 85,
        skills: ['After Effects', 'Premiere Pro', '3D Animation', 'Motion Graphics'],
        location: 'Los Angeles, USA',
        isPremium: false,
        bio: 'Creative video producer specializing in engaging animations and promotional videos.',
        languages: ['English', 'Spanish'],
        responseTime: '4 hours',
        memberSince: '2020',
    },
    {
        id: 5,
        name: 'Lisa Anderson',
        title: 'Voice Over Artist',
        avatar: 'https://images.unsplash.com/photo-1487412720507-e7ab37603c6f?w=200&h=200&fit=crop',
        rating: 4.9,
        reviews: 412,
        completedProjects: 580,
        hourlyRate: 70,
        skills: ['Voice Acting', 'Narration', 'Commercial VO', 'Character Voices'],
        location: 'Toronto, Canada',
        isPremium: true,
        bio: 'Professional voice over artist with a versatile range for commercials, audiobooks, and more.',
        languages: ['English'],
        responseTime: '1 hour',
        memberSince: '2019',
    },
    {
        id: 6,
        name: 'James Wilson',
        title: 'Full-Stack Developer',
        avatar: 'https://images.unsplash.com/photo-1472099645785-5658abf4ff4e?w=200&h=200&fit=crop',
        rating: 5.0,
        reviews: 678,
        completedProjects: 890,
        hourlyRate: 120,
        skills: ['React', 'Node.js', 'Python', 'AWS'],
        location: 'Toronto, Canada',
        isPremium: true,
        bio: 'Experienced developer building scalable web applications with modern technologies and best practices.',
        languages: ['English'],
        responseTime: '2 hours',
        memberSince: '2017',
    },
    {
        id: 7,
        name: 'Rachel Green',
        title: 'Business Consultant',
        avatar: 'https://images.unsplash.com/photo-1489424731084-a5d8b219a5bb?w=200&h=200&fit=crop',
        rating: 4.8,
        reviews: 234,
        completedProjects: 310,
        hourlyRate: 95,
        skills: ['Business Planning', 'Financial Modeling', 'Strategy', 'Market Research'],
        location: 'Chicago, USA',
        isPremium: false,
        bio: 'MBA graduate helping startups and SMEs develop winning business strategies.',
        languages: ['English'],
        responseTime: '3 hours',
        memberSince: '2021',
    },
    {
        id: 8,
        name: 'Tom Harris',
        title: 'Fitness Coach',
        avatar: 'https://images.unsplash.com/photo-1463453091185-61582044d556?w=200&h=200&fit=crop',
        rating: 4.9,
        reviews: 567,
        completedProjects: 720,
        hourlyRate: 55,
        skills: ['Personal Training', 'Nutrition', 'Weight Loss', 'Muscle Building'],
        location: 'Miami, USA',
        isPremium: true,
        bio: 'Certified fitness trainer helping clients achieve their health and wellness goals.',
        languages: ['English'],
        responseTime: '2 hours',
        memberSince: '2019',
    },
    {
        id: 9,
        name: 'Alex Turner',
        title: 'Product Photographer',
        avatar: 'https://images.unsplash.com/photo-1506794778202-cad84cf45f1d?w=200&h=200&fit=crop',
        rating: 4.8,
        reviews: 156,
        completedProjects: 234,
        hourlyRate: 80,
        skills: ['Product Photography', 'Photo Editing', 'Lighting', 'Retouching'],
        location: 'Austin, USA',
        isPremium: false,
        bio: 'Professional photographer specializing in e-commerce and product photography.',
        languages: ['English'],
        responseTime: '4 hours',
        memberSince: '2021',
    },
    {
        id: 10,
        name: 'Chris Brown',
        title: 'WordPress Developer',
        avatar: 'https://images.unsplash.com/photo-1519345182560-3f2917c472ef?w=200&h=200&fit=crop',
        rating: 4.7,
        reviews: 289,
        completedProjects: 412,
        hourlyRate: 65,
        skills: ['WordPress', 'PHP', 'WooCommerce', 'Plugin Development'],
        location: 'Seattle, USA',
        isPremium: false,
        bio: 'WordPress expert creating custom themes and plugins for businesses of all sizes.',
        languages: ['English'],
        responseTime: '3 hours',
        memberSince: '2020',
    },
    {
        id: 11,
        name: 'Nina Patel',
        title: 'Email Marketing Specialist',
        avatar: 'https://images.unsplash.com/photo-1534528741775-53994a69daeb?w=200&h=200&fit=crop',
        rating: 4.9,
        reviews: 234,
        completedProjects: 345,
        hourlyRate: 70,
        skills: ['Email Marketing', 'Mailchimp', 'Automation', 'Copywriting'],
        location: 'Mumbai, India',
        isPremium: true,
        bio: 'Email marketing expert helping businesses increase conversions through targeted campaigns.',
        languages: ['English', 'Hindi'],
        responseTime: '2 hours',
        memberSince: '2020',
    },
    {
        id: 12,
        name: 'Ryan Cooper',
        title: 'Podcast Producer',
        avatar: 'https://images.unsplash.com/photo-1492562080023-ab3db95bfbce?w=200&h=200&fit=crop',
        rating: 4.8,
        reviews: 178,
        completedProjects: 267,
        hourlyRate: 60,
        skills: ['Audio Editing', 'Sound Design', 'Mixing', 'Mastering'],
        location: 'Nashville, USA',
        isPremium: false,
        bio: 'Audio engineer and podcast producer with a passion for storytelling through sound.',
        languages: ['English'],
        responseTime: '3 hours',
        memberSince: '2021',
    },
    {
        id: 13,
        name: 'Olivia Martinez',
        title: 'Technical Writer',
        avatar: 'https://images.unsplash.com/photo-1544005313-94ddf0286df2?w=200&h=200&fit=crop',
        rating: 4.9,
        reviews: 267,
        completedProjects: 389,
        hourlyRate: 75,
        skills: ['Technical Writing', 'Documentation', 'API Docs', 'User Guides'],
        location: 'Berlin, Germany',
        isPremium: true,
        bio: 'Technical writer creating clear, concise documentation for software products.',
        languages: ['English', 'German'],
        responseTime: '2 hours',
        memberSince: '2019',
    },
    {
        id: 14,
        name: 'Sophia Lee',
        title: 'Virtual Assistant',
        avatar: 'https://images.unsplash.com/photo-1508214751196-bcfd4ca60f91?w=200&h=200&fit=crop',
        rating: 4.8,
        reviews: 412,
        completedProjects: 678,
        hourlyRate: 45,
        skills: ['Admin Support', 'Email Management', 'Scheduling', 'Data Entry'],
        location: 'Singapore',
        isPremium: false,
        bio: 'Reliable virtual assistant helping busy professionals manage their daily tasks.',
        languages: ['English', 'Mandarin'],
        responseTime: '1 hour',
        memberSince: '2020',
    },
    {
        id: 15,
        name: 'Maya Singh',
        title: 'Yoga Instructor',
        avatar: 'https://images.unsplash.com/photo-1531123897727-8f129e1688ce?w=200&h=200&fit=crop',
        rating: 5.0,
        reviews: 389,
        completedProjects: 512,
        hourlyRate: 50,
        skills: ['Yoga', 'Meditation', 'Mindfulness', 'Wellness Coaching'],
        location: 'Bali, Indonesia',
        isPremium: true,
        bio: 'Certified yoga instructor guiding students on their journey to wellness and inner peace.',
        languages: ['English', 'Hindi'],
        responseTime: '2 hours',
        memberSince: '2019',
    },
];

export const testimonials = [
    {
        id: 1,
        name: 'John Smith',
        role: 'CEO, TechStart Inc.',
        avatar: 'https://images.unsplash.com/photo-1560250097-0b93528c311a?w=100&h=100&fit=crop',
        rating: 5,
        text: 'Outstanding platform! Found the perfect developer for our project. The quality of work exceeded our expectations.',
    },
    {
        id: 2,
        name: 'Maria Garcia',
        role: 'Marketing Director',
        avatar: 'https://images.unsplash.com/photo-1573496359142-b8d87734a5a2?w=100&h=100&fit=crop',
        rating: 5,
        text: 'Incredible experience working with talented freelancers. Our marketing campaigns have never been better!',
    },
    {
        id: 3,
        name: 'Robert Taylor',
        role: 'Startup Founder',
        avatar: 'https://images.unsplash.com/photo-1556157382-97eda2d62296?w=100&h=100&fit=crop',
        rating: 5,
        text: 'This platform connected us with amazing talent. Highly recommend for anyone looking for quality freelancers.',
    },
];

export const stats = [
    { label: 'Jobs Posted', value: '2.5M+', icon: '💼' },
    { label: 'Freelancers', value: '500K+', icon: '👥' },
    { label: 'Projects Completed', value: '3.2M+', icon: '✅' },
    { label: 'Total Earnings', value: '$1.5B+', icon: '💰' },
];

export const faqs = [
    {
        id: 1,
        category: 'General',
        question: 'How do I get started as a freelancer?',
        answer: 'Simply create an account, complete your profile with your skills and portfolio, and start browsing available projects. You can also create service listings for clients to discover.',
    },
    {
        id: 2,
        category: 'Payments',
        question: 'What payment methods are accepted?',
        answer: 'We accept all major credit cards, PayPal, and bank transfers. All payments are securely processed through our platform.',
    },
    {
        id: 3,
        category: 'Payments',
        question: 'How does the escrow system work?',
        answer: 'When a client hires you, they deposit funds into escrow. Once you complete the work and the client approves, the funds are released to your account.',
    },
    {
        id: 4,
        category: 'Payments',
        question: 'What are the fees?',
        answer: 'We charge a 10% service fee on all transactions. There are no hidden fees or monthly subscriptions required.',
    },
    {
        id: 5,
        category: 'Freelancers',
        question: 'How do I build my reputation?',
        answer: 'Deliver quality work on time, communicate effectively with clients, and encourage satisfied clients to leave reviews. Building a strong portfolio also helps.',
    },
    {
        id: 6,
        category: 'Clients',
        question: 'How do I choose the right freelancer?',
        answer: 'Review their portfolio, read client reviews, check their ratings, and communicate with them before hiring to ensure they understand your requirements.',
    },
    {
        id: 7,
        category: 'General',
        question: 'Is there customer support available?',
        answer: 'Yes, our support team is available 24/7 via email and live chat to assist with any questions or issues.',
    },
    {
        id: 8,
        category: 'Clients',
        question: 'What if I\'m not satisfied with the work?',
        answer: 'We offer a dispute resolution process. If you\'re not satisfied, you can request revisions or open a dispute, and our team will help mediate.',
    },
];

export const reviews = [
    {
        id: 1,
        serviceId: 1,
        freelancerId: 1,
        clientName: 'Jennifer Adams',
        clientAvatar: 'https://images.unsplash.com/photo-1580489944761-15a19d654956?w=100&h=100&fit=crop',
        rating: 5,
        comment: 'Absolutely amazing work! Sarah delivered exactly what I needed and even exceeded my expectations. Highly recommended!',
        date: '2024-11-15',
        helpful: 12,
    },
    {
        id: 2,
        serviceId: 1,
        freelancerId: 1,
        clientName: 'Mark Thompson',
        clientAvatar: 'https://images.unsplash.com/photo-1599566150163-29194dcaad36?w=100&h=100&fit=crop',
        rating: 5,
        comment: 'Great communication and fast delivery. The logo design is perfect for our brand!',
        date: '2024-11-10',
        helpful: 8,
    },
    {
        id: 3,
        serviceId: 2,
        freelancerId: 2,
        clientName: 'Laura Martinez',
        clientAvatar: 'https://images.unsplash.com/photo-1607746882042-944635dfe10e?w=100&h=100&fit=crop',
        rating: 5,
        comment: 'Michael is an SEO wizard! Our website traffic increased by 300% in just 2 months.',
        date: '2024-11-20',
        helpful: 15,
    },
    {
        id: 4,
        serviceId: 6,
        freelancerId: 6,
        clientName: 'David Kim',
        clientAvatar: 'https://images.unsplash.com/photo-1570295999919-56ceb5ecca61?w=100&h=100&fit=crop',
        rating: 5,
        comment: 'James built our entire platform from scratch. Professional, skilled, and reliable!',
        date: '2024-11-18',
        helpful: 20,
    },
];

export const portfolioItems = [
    {
        id: 1,
        freelancerId: 1,
        title: 'Tech Startup Branding',
        description: 'Complete brand identity including logo, color palette, and brand guidelines',
        image: 'https://images.unsplash.com/photo-1558655146-9f40138edfeb?w=800&h=600&fit=crop',
        category: 'Branding',
        tags: ['Logo Design', 'Brand Identity', 'Guidelines'],
    },
    {
        id: 2,
        freelancerId: 1,
        title: 'E-commerce UI Design',
        description: 'Modern and clean UI design for online fashion store',
        image: 'https://images.unsplash.com/photo-1559028012-481c04fa702d?w=800&h=600&fit=crop',
        category: 'UI/UX',
        tags: ['UI Design', 'E-commerce', 'Mobile App'],
    },
    {
        id: 3,
        freelancerId: 2,
        title: 'SaaS Marketing Campaign',
        description: 'Complete SEO and content marketing strategy that increased organic traffic by 400%',
        image: 'https://images.unsplash.com/photo-1432888622747-4eb9a8f2c293?w=800&h=600&fit=crop',
        category: 'Marketing',
        tags: ['SEO', 'Content Marketing', 'Analytics'],
    },
    {
        id: 4,
        freelancerId: 6,
        title: 'Real Estate Platform',
        description: 'Full-stack property listing platform with advanced search and filters',
        image: 'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=800&h=600&fit=crop',
        category: 'Web Development',
        tags: ['React', 'Node.js', 'MongoDB'],
    },
];

export const orders = [
    {
        id: 1,
        serviceId: 1,
        serviceName: 'I will design a modern logo for your business',
        freelancerId: 1,
        freelancerName: 'Sarah Johnson',
        clientName: 'John Doe',
        status: 'in_progress',
        price: 150,
        orderDate: '2024-12-01',
        deliveryDate: '2024-12-04',
        thumbnail: 'https://images.unsplash.com/photo-1626785774573-4b799315345d?w=200&h=150&fit=crop',
    },
    {
        id: 2,
        serviceId: 6,
        serviceName: 'Full-stack web application development',
        freelancerId: 6,
        freelancerName: 'James Wilson',
        clientName: 'Jane Smith',
        status: 'completed',
        price: 500,
        orderDate: '2024-11-15',
        deliveryDate: '2024-11-29',
        thumbnail: 'https://images.unsplash.com/photo-1498050108023-c5249f4df085?w=200&h=150&fit=crop',
    },
    {
        id: 3,
        serviceId: 3,
        serviceName: 'Write engaging blog content and articles',
        freelancerId: 3,
        freelancerName: 'Emma Williams',
        clientName: 'Mike Johnson',
        status: 'delivered',
        price: 80,
        orderDate: '2024-12-03',
        deliveryDate: '2024-12-05',
        thumbnail: 'https://images.unsplash.com/photo-1455390582262-044cdead277a?w=200&h=150&fit=crop',
    },
];
