export const serviceDetails = {
    1: {
        id: 1,
        description: `I specialize in creating modern, memorable logos that perfectly represent your brand identity. With over 10 years of experience in graphic design, I've helped hundreds of businesses establish their visual presence.

**What you'll get:**
- Unique, custom logo design
- Multiple concepts to choose from
- Unlimited revisions until you're satisfied
- Source files in AI, PSD, and PNG formats
- Full commercial rights

**My Process:**
1. Understanding your brand and vision
2. Research and concept development
3. Initial design presentations
4. Refinement based on your feedback
5. Final delivery with all file formats`,

        packages: [
            {
                name: 'Basic',
                price: 150,
                deliveryTime: '3 days',
                revisions: '3 revisions',
                features: [
                    '2 initial concepts',
                    '3 revisions',
                    'High-resolution files',
                    'Transparent PNG',
                    'Commercial use',
                ],
            },
            {
                name: 'Standard',
                price: 250,
                deliveryTime: '5 days',
                revisions: '5 revisions',
                features: [
                    '4 initial concepts',
                    '5 revisions',
                    'High-resolution files',
                    'Source files (AI, PSD)',
                    'Transparent PNG',
                    'Social media kit',
                    'Commercial use',
                ],
                popular: true,
            },
            {
                name: 'Premium',
                price: 400,
                deliveryTime: '7 days',
                revisions: 'Unlimited',
                features: [
                    '6 initial concepts',
                    'Unlimited revisions',
                    'High-resolution files',
                    'Source files (AI, PSD, SVG)',
                    'Transparent PNG',
                    'Social media kit',
                    'Brand style guide',
                    '3D mockups',
                    'Commercial use',
                ],
            },
        ],

        faqs: [
            {
                question: 'What do you need from me to get started?',
                answer: 'I\'ll need your company name, industry, target audience, preferred colors (if any), and any specific ideas or inspiration you have in mind.',
            },
            {
                question: 'Do you provide the source files?',
                answer: 'Yes! The Standard and Premium packages include source files in AI and PSD formats. The Basic package includes high-resolution PNG files.',
            },
            {
                question: 'Can I request changes after delivery?',
                answer: 'Absolutely! All packages include revisions. The number varies by package, with Premium offering unlimited revisions.',
            },
        ],

        gallery: [
            'https://images.unsplash.com/photo-1626785774573-4b799315345d?w=800&h=600&fit=crop',
            'https://images.unsplash.com/photo-1561070791-2526d30994b5?w=800&h=600&fit=crop',
            'https://images.unsplash.com/photo-1558655146-9f40138edfeb?w=800&h=600&fit=crop',
        ],
    },

    2: {
        id: 2,
        description: `Boost your website's visibility and drive organic traffic with professional SEO optimization. I use proven strategies and white-hat techniques to improve your search engine rankings.

**What's Included:**
- Comprehensive SEO audit
- Keyword research and analysis
- On-page optimization
- Technical SEO improvements
- Monthly performance reports

**My Approach:**
I focus on sustainable, long-term results rather than quick fixes. Every strategy is tailored to your specific business goals and target audience.`,

        packages: [
            {
                name: 'Basic',
                price: 200,
                deliveryTime: '5 days',
                revisions: '1 revision',
                features: [
                    'SEO audit report',
                    'Keyword research (10 keywords)',
                    'On-page optimization',
                    'Meta tags optimization',
                    'Basic recommendations',
                ],
            },
            {
                name: 'Standard',
                price: 400,
                deliveryTime: '7 days',
                revisions: '2 revisions',
                features: [
                    'Comprehensive SEO audit',
                    'Keyword research (25 keywords)',
                    'On-page optimization',
                    'Technical SEO fixes',
                    'Content optimization',
                    'Competitor analysis',
                    'Monthly report',
                ],
                popular: true,
            },
            {
                name: 'Premium',
                price: 800,
                deliveryTime: '14 days',
                revisions: '3 revisions',
                features: [
                    'Full SEO audit',
                    'Keyword research (50 keywords)',
                    'Complete on-page optimization',
                    'Technical SEO implementation',
                    'Content strategy',
                    'Link building strategy',
                    'Competitor analysis',
                    'Monthly reports (3 months)',
                ],
            },
        ],

        faqs: [
            {
                question: 'How long does it take to see results?',
                answer: 'SEO is a long-term strategy. You can expect to see initial improvements in 2-3 months, with significant results in 4-6 months.',
            },
            {
                question: 'Do you guarantee first page rankings?',
                answer: 'While I can\'t guarantee specific rankings (no one can), I use proven strategies that have consistently improved my clients\' visibility.',
            },
        ],

        gallery: [
            'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=800&h=600&fit=crop',
            'https://images.unsplash.com/photo-1432888622747-4eb9a8f2c293?w=800&h=600&fit=crop',
        ],
    },

    6: {
        id: 6,
        description: `Transform your ideas into reality with a custom full-stack web application. I build scalable, secure, and user-friendly applications using modern technologies.

**Technologies I Use:**
- Frontend: React, Next.js, Vue.js
- Backend: Node.js, Express, Python
- Database: MongoDB, PostgreSQL, MySQL
- Cloud: AWS, Google Cloud, Heroku

**What You Get:**
- Clean, maintainable code
- Responsive design
- RESTful API development
- Database design and optimization
- Deployment and hosting setup
- Documentation`,

        packages: [
            {
                name: 'Basic',
                price: 500,
                deliveryTime: '14 days',
                revisions: '2 revisions',
                features: [
                    'Simple web application',
                    'Up to 5 pages',
                    'Basic database integration',
                    'Responsive design',
                    'Basic documentation',
                ],
            },
            {
                name: 'Standard',
                price: 1200,
                deliveryTime: '21 days',
                revisions: '3 revisions',
                features: [
                    'Complex web application',
                    'Up to 15 pages',
                    'Full database integration',
                    'User authentication',
                    'Admin panel',
                    'API development',
                    'Responsive design',
                    'Complete documentation',
                ],
                popular: true,
            },
            {
                name: 'Premium',
                price: 2500,
                deliveryTime: '30 days',
                revisions: '5 revisions',
                features: [
                    'Enterprise web application',
                    'Unlimited pages',
                    'Advanced database design',
                    'User authentication & authorization',
                    'Admin panel',
                    'RESTful API',
                    'Third-party integrations',
                    'Payment gateway integration',
                    'Cloud deployment',
                    'Complete documentation',
                    '30 days support',
                ],
            },
        ],

        faqs: [
            {
                question: 'What information do you need to start?',
                answer: 'I\'ll need a detailed description of your project requirements, target audience, preferred technologies, and any design references you have.',
            },
            {
                question: 'Do you provide ongoing maintenance?',
                answer: 'Yes! I offer maintenance packages separately. The Premium package includes 30 days of free support after delivery.',
            },
            {
                question: 'Can you work with my existing codebase?',
                answer: 'Absolutely! I can integrate new features into existing applications or refactor legacy code.',
            },
        ],

        gallery: [
            'https://images.unsplash.com/photo-1498050108023-c5249f4df085?w=800&h=600&fit=crop',
            'https://images.unsplash.com/photo-1547658719-da2b51169166?w=800&h=600&fit=crop',
            'https://images.unsplash.com/photo-1460925895917-afdab827c52f?w=800&h=600&fit=crop',
        ],
    },
};
